#include <18F2431.h>           // Standard Header file for the PIC18F4431 device
#include <stdlib.h>
#include <math.h>

#define  CLOCK_SP    8000000 // Clock Speed(Hz)

// Device Specification
#fuses INTRC                    // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()


#use rs232(baud=115200 , xmit=pin_c6 ,rcv=pin_c7 ,stream=CAM ,errors)
#use rs232(baud=38400 , xmit=pin_C4 ,rcv=pin_C5 ,stream=HOST  ,errors)


unsigned long int i, TL, TR, BL, BR, cTL, cTR, cBL, cBR;
unsigned int flag,x, y, j, k, rTL,rTR,rBL,rBR,it;
unsigned int DataIn[300],TM, BM, CM,lineL,lineR,inc,ref;
signed int dirL,dirR,dirM , IncINT, D, M, ACM,OC,OCC;
Unsigned long int LPF, RPF, CDF, Period;

//unsigned int R1[20],R2[20],R3[20],R4[20],R5[20],R6[20],R7[20],R8[20],R9[20],R10[20];
//unsigned int R11[20],R12[20],R13[20],R14[20],R15[20];


void Cam_mode(void){

   fputc(0xAA,CAM); fputc(0x06,CAM); fputc(0x03,CAM);  // [170] [Length = 6] [command = 3]
   fputc(0x00,CAM); fputc(0x00,CAM);                   // [X = 0] [Y = 0]
   fputc(0xA0,CAM); fputc(0x78,CAM); fputc(0x03,CAM);  // [W = 160 ] [H = 120 ] [mode = 3]

   //fprintf(HOST,"\n\r Setted Mode \n\r");

}

// ------------------  CAM [8] -----------------------------------
void CAM_8(void){

   fputc(0xAA,CAM); fputc(0x01,CAM); fputc(0x08,CAM); // [170] [Length = 1] [command = 8]

   //fprintf(HOST,"\n\r Sent Command [8] \n\r");

}


// ------------------  CAM [9] -----------------------------------
void CAM_9(void){

   fputc(0xAA,CAM); fputc(0x05,CAM); fputc(0x09,CAM); // [170] [Length = 5] [command = 9]
   fputc(0x00,CAM); fputc(0x00,CAM);                  // [X = 0] [Y = 0]
   fputc(0xA0,CAM); fputc(0x78,CAM);                  // [W = 160 ] [H = 120 ]
   //fprintf(HOST,"\n\r Sent Command [8] \n\r");


}




void main(void){


   for(i=0;i<300;i++)
      {
      DataIn[i] = 255;
      }


   // ---------------------  setup PWM  --------------------------------------//
   //period = 3749;
   // Frequency = Fosc / (No.of CLOCK_DIV * (period+1) * postscale)
  // period = 1875;
   period = 625;
   setup_power_pwm_pins(PWM_BOTH_ON,PWM_BOTH_ON,PWM_BOTH_ON,PWM_BOTH_ON);
   setup_power_pwm(PWM_CLOCK_DIV_128|PWM_FREE_RUN,1,0,period,0,1,0);
   // frequency is to be 50 Hz
   //---------------------------------------------------------------------------
 //  CDF = 360; LPF = 360; RPF = 360;
   //   CDF = 130-10; LPF = 360; RPF = 360;
 //  CDF = 130+80;
     CDF=165;

   flag = 1;
   i = 0; j = 0; k = 0;

   set_power_pwm0_duty(CDF);
 //  set_power_pwm2_duty(LPF);
 //  set_power_pwm4_duty(RPF);
   delay_ms(400);
   fprintf(HOST,"\f\n\r");
   delay_ms(100);

    D = 1;
    M = 1;
    ref=55;




 //  fprintf(HOST,"\n\r");
 //  fprintf(HOST,"\n\r>> cBL :cTL : rTL : cBR : cTR : rTR : dirM : TM : BM : CM : ACM : CDF \n\r");





   delay_ms(1000);


   Cam_mode();
   delay_ms(10);
   CAM_8();
   OC=20;
   OCC=0;
   while(true)
   {
//OCC=OCC+OC;
/*
   if(OCC>=20)
   {
   OCC=20;
   OC=-10;
   }
   if (OCC<=-20)
   {
   OCC=-20;
   OC=10;
   }
*/ 
//   fprintf(HOST,">> %d %d  \n\r",OCC,OC);

            for(i=0;i<300;i++)
            {

               DataIn[i] = fgetc(CAM);

            }

            i = 0;
            for(i=0;i<300;i++)
            {
            if(DataIn[i] < 75)
               {
               DataIn[i] = 1;
               }
            else
               {
               DataIn[i] = 0;
               }
            }

            i = 0;
            for(y=0;y<15;y++)
            {
               for(x=0;x<20;x++)
                  {

      //           fprintf(HOST,"%u ",DataIn[i]);
                  delay_us(50);
                  i++;
                  }
               fprintf(HOST,"\n\r");
            }


// -----------------------------------------------------------------------------
// ---------------------------- Find Corner ------------------------------------
// -----------------------------------------------------------------------------


// ------------------------- Find top corner  ----------------------------------
flag = 1;
            for(i=0;i<300;i++)
               {
               if (flag == 1)
                  {
               // ----------  TL  -----------
                  if (DataIn[i] == 1)
                     {
                        if (DataIn[i+1] == 1)
                           {
                           TL = i;
                           //fprintf(HOST," \n\r >> %lu ",TL);
                           flag++;
                           }
                     }
                  }

               // ----------  TR  -----------
                else if (flag == 2)
                  {
                  if (DataIn[i] == 1)
                     {
                     if (DataIn[i+1] != 1)
                        {
                        TR = i;
                        //fprintf(HOST,"\n\r >> %lu ",TR);
                        flag++;
                        }
                     }
                  }

               }

// ------------------------  Find Bottom corner --------------------------------
flag = 1;
            for(i=300;i>0;i--)
               {
               if (flag == 1)
                  {
               // -------  BR ----------
                  if (DataIn[i] == 1)
                     {
                     if (DataIn[i-1] == 1)
                        {
                        BR = i;
                        //fprintf(HOST,"\n\r >> %lu ",BR);
                        flag++;
                        }
                     }
                  }
               else if(flag == 2)
                  {
                  if (DataIn[i] == 1)
                     {
                     if (DataIn[i-1] != 1)
                        {
                        BL = i;
                        //fprintf(HOST,"\n\r >> %lu ",BL);
                        flag++;
                        }
                     }
                  }
               }


// -----------------------------------------------------------------------------
// ----------------------  Indentify in X-Y coordinate  ------------------------
// -----------------------------------------------------------------------------
      cTL = TL; cTR = TR; cBL = BL; cBR = BR;
      rTL = 15; rTR = 15; rBL = 15; rBR = 15;

      while (cTL >= 20) { cTL = cTL - 20; rTL--;}
      while (cTR >= 20) { cTR = cTR - 20; rTR--;}
      while (cBL >= 20) { cBL = cBL - 20; rBL--;}
      while (cBR >= 20) { cBR = cBR - 20; rBR--;}

      cTL++; cTR++; cBL++; cBR++;

      //fprintf(HOST,"\n\r >> cTL: %lu ,rTL: %u ,cTR: %lu ,rTR: %u",cTL,rTL,cTR,rTR);
      //fprintf(HOST,"\n\r >> cBL: %lu ,rBL: %u ,cBR: %lu ,rBR: %u",cBL,rBL,cBR,rBR);


// -----------------------------------------------------------------------------
// ----------------------  Calculate direction ---------------------------------
// -----------------------------------------------------------------------------

      dirL = cTL-cBL; dirR = cTR-cBR;
      TM = (cTL+cTR)/2; BM = (cBL+cBR)/2;
      CM = (TM+BM)/2;
      lineL = rTR-rBR;

      //fprintf(HOST,"\n\r >> dirL: %d ,dirR: %d",dirL,dirR);

// ----------------  Define Direction & Value position  ------------------------




      if(dirL < -1 || dirR < -1)
         {
         if(dirL <= dirR)
            {
            dirM = D*dirL;
         
            }
         else
            {
            dirM = D*dirR;
      
            }
         //fprintf(HOST,"\n\r >> dirM : %d",dirM);
         //fprintf(HOST,"\n\r >> Turn Left");
         }
      else if(dirL > 1 || dirR > 1)
         {
         if(dirL >= dirR)
            {
            dirM = D*dirL;
            
            }
         else
            {
            dirM = D*dirR;
            
            }
         //fprintf(HOST,"\n\r >> dirM : %d",dirM);
         //fprintf(HOST,"\n\r >> Turn Right");
         }
      else
         {

         dirM = 0;
         //fprintf(HOST,"\n\r >> Go straight...");
         }


      ACM = M*(CM-10);
// -----------------------------------------------------------------------------
// ------------------------  Cal. PWM control  ---------------------------------
// -----------------------------------------------------------------------------

// -------------------------  Edit position  -----------------------------------

      CDF = 165 - dirM - ACM;
     
      if(CDF >= 210)
         {
         CDF = 210;
         }
      else if(CDF <= 120)
         {
         CDF = 120;
         }
// -------------------------  Edit PWM Value  ----------------------------------

      if(k==0)
         {
         CDF = CDF + OC;
         k++;
         //fprintf(HOST,"\n\r >> CDF(k=0) : %lu",CDF);
         }
      else if(k==1)
         {
         CDF = CDF - OC;
         k--;
         //fprintf(HOST,"\n\r >> CDF(k=1) : %lu",CDF);
         }


  

// -----------------------------------------------------------------------------
// --------------------------  Set UP PWM  -------------------------------------
// -----------------------------------------------------------------------------

      set_power_pwm0_duty(CDF);
//      set_power_pwm2_duty(LPF);
//      set_power_pwm4_duty(RPF);

// -----------------------------------------------------------------------------
// ---------------------------  CAM order  -------------------------------------
// -----------------------------------------------------------------------------

fprintf(HOST,">> %lu : %lu : %u : %lu : %lu : %u : %d : %u : %u : %u : %d : %lu \n\r",cBL,cTL,rTL,cBR,cTR,rTR,dirM,TM,BM,CM,ACM,CDF);
delay_ms(250);
CAM_8();

   }
}
